[![GitHub license](https://img.shields.io/github/license/Nodlik/StPageFlip)](https://github.com/Nodlik/StPageFlip/blob/master/LICENSE) [![npm](https://img.shields.io/npm/v/page-flip)](https://www.npmjs.com/package/page-flip) [![npm](https://img.shields.io/npm/dm/page-flip)](https://npmcharts.com/compare/page-flip?minimal=true) [![](https://img.shields.io/badge/support-buymeacoffee-orange)](https://www.buymeacoffee.com/nndlik)

# StPageFlip

Powerful, simple, and flexible JS Library for creating realistic and beautiful page turning effect.

![](video.gif)

### Features

-   Works with simple images on canvas and complex HTML blocks
-   Has simple API and flexible configuration
-   Compatible with mobile devices
-   Supports landscape and portrait screen mode
-   Supports soft and hard page types (only in HTML mode)
-   No dependencies

Demo and docs: https://nodlik.github.io/StPageFlip/

For React.JS you can use: https://nodlik.github.io/react-pageflip/

Docs (generated by TypeDoc): https://nodlik.github.io/StPageFlip/docs/index.html

### Installation

You can install the latest version using npm:

`npm install page-flip`

Or download bundle from Github

### Usage

If you've installed the package from npm, you should import PageFlip from page-flip package, or just use `<script/>` tag:

```html
<script src="{path/to/scripts}/page-flip.browser.js"></script>
```

To create a new PageFlip object:

```js
import { PageFlip } from 'page-flip';

const pageFlip = new PageFlip(htmlParentElement, settings);

// or if you're using a script tag and page-flip.browser.js:
const pageFlip = new St.PageFlip(htmlParentElement, settings);
```

`htmlParentElement - HTMLElement`- root element, where the book will be created

`settings: object` - configuration object.

To draw on a canvas, use `loadFromImages`:

```js
pageFlip.loadFromImages(['path/to/image1.jpg', 'path/to/image2.jpg' ... ]);
```

To load page from html elements - use `loadFromHtml`:

```js
pageFlip.loadFromHtml(items);
```

For example:

```html
<div id="book">
    <div class="my-page" data-density="hard">
        Page Cover
    </div>
    <div class="my-page">
        Page one
    </div>
    <div class="my-page">
        Page two
    </div>
    <div class="my-page">
        Page three
    </div>
    <div class="my-page">
        Page four
    </div>
    <div class="my-page" data-density="hard">
        Last page
    </div>
</div>
```

```js
const pageFlip = new PageFlip(document.getElementById('book'), {
    width: 400, // required parameter - base page width
    height: 600, // required parameter - base page height
});

pageFlip.loadFromHTML(document.querySelectorAll('.my-page'));
```

Use `data-density="hard"` attribute to specify page type (`soft | hard`) and define flipping animation.

### Config

To set configuration define these parameters when creating an object:

-   `width: number` - required
-   `height: number` - required
-   `size: ("fixed", "stretch")` - default: `"fixed"` Whether the book will be stretched under the parent element or not
-   `minWidth, maxWidth, minHeight, maxHeight: number` You must set threshold values ​​with size: `"stretch"`
-   `drawShadow: bool` - default: `true` Draw shadows or not when page flipping
-   `flippingTime: number` (milliseconds) - default: `1000` Flipping animation time
-   `usePortrait: bool` - default: `true` Enable switching to portrait mode. !This mode uses cloning of html elements (pages)
-   `startZIndex: number` - default: `0` Initial value to z-index
-   `startPage: number` - default: `0` Page number from which to start viewing
-   `autoSize: bool` - default: `true` If this value is true, the parent element will be equal to the size of the book
-   `maxShadowOpacity: number [0..1]` - default: `1` Shadow intensity (1: max intensity, 0: hidden shadows)
-   `showCover: boolean` - default: `false` If this value is true, the first and the last pages will be marked as hard and will be shown in single page mode
-   `mobileScrollSupport: boolean` - default: `true` disable content scrolling when touching a book on mobile devices
-   `swipeDistance: number` - default: `30` (px) minimum distance to detect swipe (new on 1.1.0)
-   `clickEventForward: boolean` - default: `true` forwarding click events to the page children html elements (only for `a` and `button` tags) (new on 1.1.0)
-   `useMouseEvents: boolean` - default: `true` using mouse and touch events to page flipping (new on 1.2.0)
-   `disableFlipByClick: boolean` - default: `false` if this value is true, flipping by clicking on the whole book will be locked. Clicking will only work in corners (new on 2.0.3)

### Events

To listen events use the method `on`:

```js
pageFlip.on('flip', (e) => {
    // callback code
    alert(e.data); // current page number
});
```

Available events:

-   `flip: number` - triggered by page turning
-   `changeOrientation: ("portrait", "landscape")` - triggered when page orientation changes
-   `changeState: ("user_fold", "fold_corner", "flipping", "read")` - triggered when the state of the book changes
-   `init: ({page: number, mode: 'portrait', 'landscape'})` - triggered when the book is init and the start page is loaded. Listen (`on`) this event before using the "loadFrom..." methods
-   `update: ({page: number, mode: 'portrait', 'landscape'})` - triggered when the book pages are updated (using the "updateFrom..." methods)

Event object has two fields: `data: number | string` and `object: PageFlip`

### Methods

-   `getPageCount: number` - Get number of all pages
-   `getOrientation: 'portrait', 'landscape'` - Get the current orientation: portrait or landscape
-   `getBoundsRect: PageRect` - Get current book sizes and position
-   `getCurrentPageIndex: number` - Get the current page number (starts at 0)
-   `turnToPage(pageNum: number)` - Turn to the specified page number (without animation)
-   `turnToNextPage()` - Turn to the next page (without animation)
-   `turnToPrevPage()` - Turn to the previous page (without animation)
-   `flipNext(corner: 'top' | 'bottom')` - Turn to the next page (with animation)
-   `flipPrev(corner: 'top' | 'bottom')` - Turn to the previous page (with animation)
-   `flip(pageNum: number, corner: 'top' | 'bottom')` - Turn to the specified page (with animation)
-   `loadFromImages(images: ['path-to-image1.jpg', ...])` - Load page from images
-   `loadFromHtml(items: NodeListOf | HTMLElement[])` - Load page from html elements
-   `updateFromHtml(items: NodeListOf | HTMLElement[])` - Update page from html elements (new on 0.4.0)
-   `updateFromImages(images: ['path-to-image1.jpg', ...])` - Update page from images (new on 0.4.0)
-   `destroy()` - Destructor. Remove a root HTML element and all event handlers (new on 0.4.0)

### Contacts

Oleg,

<oleg.litovski9@gmail.com>

https://github.com/Nodlik/StPageFlip

[![Buy me a coffee][buymeacoffee-shield]][buymeacoffee]

[buymeacoffee]: https://www.buymeacoffee.com/nndlik
[buymeacoffee-shield]: https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png
